/*******************************************************************************
BEGIN_FILE_PROLOG:

NAME:
    PGS_CBP.h

DESCRIPTION;
    This file contains the typedefs, special defines, include files, and
    function prototypes for the PGS toolkit CBP tools.

END_FILE_PROLOG:
*******************************************************************************/

#ifndef _PGS_CBP_H_
#define _PGS_CBP_H_

/* include system include files */


/* include SMF header file */

#include <PGS_TD.h>
#include <PGS_CSC.h>

/* include error messages files */

#include <PGS_CBP_6.h>

/* logical identifier for JPL Celestial body ephemeris file */

#define DE200 10601

/* celestial body tag definitions */

#define MERCURY 1
#define VENUS   2
#define EARTH   3
#define MARS    4
#define JUPITER 5
#define SATURN  6
#define URANUS  7
#define NEPTUNE 8
#define PLUTO   9
#define MOON   10
#define SUN    11
#define SSBARY 12
#define EMBARY 13

#define STAR 999

/* Function prototypes */

extern PGSt_SMF_status
PGS_CBP_Earth_CB_Vector(
    PGSt_integer,
    char [28],
    PGSt_double [],
    PGSt_integer,
    PGSt_double [][3]);

extern PGSt_SMF_status
PGS_CBP_Sat_CB_Vector(
    PGSt_tag,
    PGSt_integer,
    char [28],
    PGSt_double [],
    PGSt_integer,
    PGSt_double [][3]);

extern PGSt_SMF_status
PGS_CBP_EphemRead(
    PGSt_double [2],
    PGSt_integer,
    PGSt_integer,
    PGSt_double [],
    PGSt_double [][3]);

extern PGSt_SMF_status
PGS_CBP_SolarTimeCoords(
    char [28],        
    PGSt_double,     
    PGSt_double *,   
    PGSt_double *,   
    PGSt_double *,   
    PGSt_double *,         
    PGSt_double *);

extern PGSt_SMF_status
PGS_CBP_body_inFOV(                      
    PGSt_integer,              
    char [28],           
    PGSt_double [],              
    PGSt_tag,          
    PGSt_integer,         
    PGSt_double [][3],       
    void *,  
    PGSt_integer,                   
    PGSt_boolean [],            
    PGSt_double [][3],         
    PGSt_double [][3]);      

#endif
