/* CVS Comment Section
 * 
 * $Log: TS_GLOBAL.h,v $
 * Revision 1.1.1.1  2011/04/08 01:26:09  hensley
 * Import for V7 OAT
 *
 * Revision 1.1.1.1  2009/08/13 18:31:50  hensley
 * First added
 *
 * Revision 1.3  2009/08/13 17:43:44  hensley
 * Changed TMI for V7 and aesthetic changes
 *
 * Revision 1.2  2009/07/02 21:01:28  hensley
 * TSDIS to PPS
 *
 * 
 * PPS CVS ^^ (module named "globals")
 * ---------------------------------------------------------------------
 * TSDIS CVS vv (module named "include")
 * 
 * Revision 1.18  2002/08/14 15:58:10  hensley
 * Fixed CVS Comment Section
 * 
 * Revision 1.17  1997/05/13 16:27:14  piper
 * Removed TK_SUCCESS and TK_FAIL.
 * 
 * Revision 1.16  1997/04/16 15:21:14  piper
 * Removed references to generic warning and error messages.
 * 
 * Revision 1.15  1997/04/15 21:38:34  hensley
 * Added PR scan rate
 * 
 * Revision 1.14  1997/04/10 16:49:54  slywczak
 * Added a macro for the HDF failure status.  HDF will always
 * return a -1 for a failed return code.
 * 
 * Revision 1.13  1996/12/06 19:32:10  dbazell
 * removed a ';' from end of #define TS_GRANULE_SIZE
 * 
 * Revision 1.12  1996/12/04  15:50:02  tim
 * Add location for IM and DM constants
 * 
 * Revision 1.11  1996/11/15  21:23:32  amak
 * Corrected ifdef statement for MAX and MIN macro.
 * 
 * Revision 1.10  1996/09/13  18:04:00  dbazell
 * Added some instrument specific values.
 * 
 * Revision 1.9  1996/09/06  13:38:15  dbazell
 * Added #defines for TS_VIRS, TS_TMI, and TS_PR
 * 
 * Revision 1.8  1996/08/28  19:02:59  dbazell
 * Added new constants RELLIPS, EMR, FLATC, OMEGA, GRAVC.
 * Added #ifndef LANGUAGE_FORTRAN around min and max macros.
 * 
 * Revision 1.7  1996/05/30  17:47:43  dbazell
 * Removed log definition which as causing conflicts.
 * 
 * Revision 1.6  1996/04/30 13:49:52  dbazell
 * Added velocity of light.
 * 
 * Revision 1.5  1996/03/27 16:08:31  dbazell
 * Added the constants and conversion factors.
 * 
 * Revision 1.4  1996/03/18 13:30:41  dbazell
 * Changed TS_FAIL to equal -1.  Added Log tag.
 * 
 */

/***************************************************************/
/* PPS global include file.  These are values that are defined */
/* globally for use by all PPS subsystems.                     */
/***************************************************************/

#ifndef __TSGLOBAL_H__
#define __TSGLOBAL_H__

/* Global PPS include file */

/* Return status values */
#define TS_SUCCESS      0
#define TS_FAIL        -1

/* Miscellaneous values */
#define TS_TRUE         1
#define TS_FALSE        0
#define TS_TMI          1
#define TS_VIRS         2
#define TS_PR           3

/* HDF Fail Indicator  */
#define TS_HDF_FAIL    -1

/* Array Dimensions */
#define TS_FNAME      128
#define TS_PATHLEN    256

/* Data types */
typedef unsigned char   byte;
typedef unsigned short  tsword;
typedef unsigned int    tslword;

/* IM and DM constants */

#define TS_GRANULE_SIZE  256

/* Missing values for various data types */
#define TS_MISS_I1   -99        /* missing value for 1-byte integer    */
#define TS_MISS_I2 -9999        /* missing value for 2 & 4-byte int    */
#define TS_MISS_F4 -9999.9      /* missing value for 4 & 8-byte float  */

/* Constants related to the different instruments */

/* The data rate of the TMI science packets in scan/sec */
#define TS_SCAN_RATE_TMI       1.89873   
#define TS_NUMPIX_TMI        208  /* Number of pixels in a scan        */
#define TS_NUM_LDIR_TMI      208  /* Number of Local directions needed */
                                  /* updated for V7 from 12 to 208     */
#define TS_LDIR_STRIDE_TMI     1  /* Stride at which local directions  */
                                  /* are computed - updated for V7     */
                                  /* from 20 to 1                      */

/* PR values */                
#define TS_NOMINAL_SCAN_RATE_PR 0.6
#define TS_NUMPIX_PR           49 /* Number of pixels in a scan        */
#define TS_NUM_LDIR_PR         49 /* Number of Local directions needed */
#define TS_LDIR_STRIDE_PR       1 /* Stride at which local directions  */
                                  /* are computed                      */

/* The data rate of the VIRS science packets in scan/sec */
#define TS_SCAN_RATE_VIRS       0.3045685 
#define TS_NUMPIX_VIRS        261 /* Number of pixels in a scan        */
#define TS_NUM_LDIR_VIRS       27 /* Number of Local directions needed */
#define TS_LDIR_STRIDE_VIRS    10 /* Stride at which local directions  */
                                  /* are computed                      */

/* Related to the planet Earth. */
#define R_EQUATOR        6378.137       /* Earth equator radius (km)   */
#define EARTHROT         7.292115855E-5 /* Earth rotation rate rad/sec */ 
#define ECCENTRICITY     0.01677        /* Earth orbital eccentricity  */
#define RELLIPS          R_EQUATOR      /* Earth equator radius (km)   */
#define EMR              6371.0         /* Earth Mean Radius (km)      */
#define FLATC            0.00335281     /* Earth oblateness coefficient*/
#define OMEGA            0.004178074622 /* Spin rate of Earth (deg/sec)*/
#define GRAVC            398600.8       /* Earth Gravitational         */
                                        /* Const. (KM**3/SEC**2)       */

/* Miscellaneous constants. */
#define E                2.718281828    /* The constant e              */
#define PI               3.141592654    /* The constant pi             */
#define PI_BY_TWO        1.570796327    /* pi divided by 2             */
#define RAD2DEG          57.29577951    /* 180 deg / pi radians        */
#define DEG2RAD          0.017453292    /* pi radians / 180 deg        */
#define TWOPI            6.283185307    /* pi times 2                  */
#define C_LIGHT_V        299792458      /* Light Velocity in m/sec     */

/* Useful C macros. */
#ifdef LANGUAGE_FORTRAN
#define MIN(a,b)         ( (a) <= (b) ? (a) : (b) )    /* min function */
#define MAX(a,b)         ( (a) >  (b) ? (a) : (b) )    /* max function */
#endif

#endif
