/*****************************************************************
BEGIN_FILE_PROLOG:

FILENAME:
  PGS_SMF.h

DESCRIPTION:
        
AUTHOR:
  Kelvin K. Wan / Applied Research Corp.
        
HISTORY:
  25-Mar-1994 Standard Convention
  18-Jul-1994 Modify to include PGS_TYPES.h
  15-Aug-1994 No longer need PGS_SMF_2.h and PGS_0.h
  23-Aug-1994 The level mask has been reordered for severity
  22-Mar-1995 MES Created new typedef struct: PGSSmfOtherGlb and
                  added member of this type to PGSSmfGlbVar.
                  This is to encapsulate the former static globals
                  (callerID, writeLogFile, useMemType, whichProc) 
                  used by the 1-file version of SMF 
  23-Mar-1995 MES Added PGSSMF_W_NO_MESSAGE_FILE
  24-Mar-1995 MES Added PGSSMF_M_NOT_IN_CACHE
  28-Mar-1995 MES Created PGS_SMF_MsgCacheInfo structure typedef
                  and added to PGSSmfShm to give shared memory
                  support for the message buffer.
  23-Mar-1995 MES Added command definitions for PGS_SMF_MsgLevel
  28-Apr-1995 MES Added function prototypes for new high-level 
                  tools PGS_SMF_Begin and PGS_SMF_End.

END_FILE_PROLOG:
*****************************************************************/

#ifndef _PGS_SMF_H
#define _PGS_SMF_H

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Debug Flag 
 */
#define PGSSMF  "pgssmf" 

/*
 * Toolkit return status 
 */
#ifndef NULL
#define NULL               0
#endif

#define PGS_TRUE           1          
#define PGS_FALSE          0
#define PGS_NULL_STR       "NULL"

#define PGSd_CALLERID_SMF     10   /* SMF is starting to init. */
#define PGSd_CALLERID_USR     11   /* User calling SMF */

/*
 * System Headers
 */
#include <limits.h>
#include <stdio.h>
#include <errno.h>
extern int   errno;            /* not POSIX definition but needed to support */
extern int   sys_nerr;         /* UNIX error/message                         */
/* extern char *sys_errlist[]; */

/*
 * Toolkit Headers 
 */
#include <PGS_TYPES.h>

typedef PGSt_integer      PGSt_SMF_status;
typedef PGSt_SMF_status   PGSt_SMF_code;
typedef PGSt_integer      PGSt_SMF_boolean;
typedef PGSt_SMF_status   pgs_status;
typedef PGSt_SMF_code     pgs_code;
typedef PGSt_SMF_boolean  pgs_boolean;

/*
 * Contants
 */
#define PGSd_SMF_CHAR_FORMFEED            0x0c   /* form feed character: Ctrl-L */
#define PGSd_SMF_NUM_OPENFILE                5   /* maximum number of opened files */
#define PGSd_SMF_USE_SHAREDMEM               0   /* use shared memory */
#define PGSd_SMF_USE_ASCIIFILE               1   /* use ascii file */
#define PGSd_SMF_WRITELOG_OFF                0   /* write to log file OFF */
#define PGSd_SMF_WRITELOG_ON                 1   /* write to log file ON */
#define PGSd_SMF_PROC_INIT                 0x2   /* initialization process */
#define PGSd_SMF_PROC_TERM                 0x4   /* termination process */
#define PGSd_SMF_PROC_USER                 0x8   /* user (PGE) process */

#define PGSd_SMF_TAG_LENGTH_MAX             61   /* message tag; 1 char. for '\0' */
#define PGSd_SMF_PATH_MAX                  256   /* maximumm path+filename; 1 char. for '\0' */
#define PGSd_SMF_MAILMSG_LEN             10001   /* mail message length */

#define PGSd_SMF_LOGICAL_LOGSTATUS       10100   /* status log file */
#define PGSd_SMF_LOGICAL_LOGREPORT       10101   /* report log file */
#define PGSd_SMF_LOGICAL_LOGUSER         10102   /* user log file */
#define PGSd_SMF_LOGICAL_TMPSTATUS       10103   /* temporary log status file */
#define PGSd_SMF_LOGICAL_TMPREPORT       10104   /* temporary log report file */
#define PGSd_SMF_LOGICAL_TMPUSER         10105   /* temporary log user file */

#define PGSd_SMF_LOGICAL_REMOTEHOSTNAME  10106   /* remote host name */
#define PGSd_SMF_LOGICAL_REMOTEPATH      10107   /* remote path to send the file */
#define PGSd_SMF_LOGICAL_MAILUSER        10108   /* send the mail to user */
#define PGSd_SMF_LOGICAL_TRANSMIT        10109   /* transmit file */

#define PGSd_SMF_LOGICAL_TMPFILE         10110   /* temporary file */
#define PGSd_SMF_LOGICAL_SHMMEM          10111   /* simulation of SMF shared memory */

/*
 * Defined contants with seed = 0 (system code)
 */
#define PGS_S_SUCCESS                                  0 
#define PGS_SH_PC_TRUNC                              243 /* 0x000000f3L */
#define PGS_SH_PC_TOOLERROR                          244 /* 0x000000f4L */
#define PGS_SH_PC_NODATA                             245 /* 0x000000f5L */
#define PGS_SH_SYS_PARAM                             246 /* 0x000000f6L */
#define PGS_SH_MEM_INIT                              247 /* 0x000000f7L */
#define PGS_SH_PC_DELETETMP                          248 /* 0x000000f8L */
#define PGS_SH_SMF_SENDRUNTIME                       249 /* 0x000000f9L */
#define PGS_SH_SMF_SENDLOGFILE                       250 /* 0x000000faL */
#define PGS_SH_MEM_TERM                              251 /* 0x000000fbL */
#define PGS_SH_SMF_LOGFILE                           252 /* 0x000000fcL */
#define PGS_SH_PC_LOADDATA                           253 /* 0x000000fdL */
#define PGS_SH_PC_ENV                                254 /* 0x000000feL */
#define PGS_SH_SMF_SHMMEM                            255 /* 0x000000ffL */
#define PGS_SH_SIGFPE                                260 /* 0x00000104L */

#define PGS_M_NULL                                  1797 /* 0x00000705L */
#define PGS_M_UNIX                                  1798 /* 0x00000706L */
#define PGS_E_HDF                                   3847 /* 0x00000f07L */
#define PGS_E_UNIX                                  3848 /* 0x00000f08L */
#define PGS_E_ECS                                   3849 /* 0x00000f09L */
#define PGS_E_TOOLKIT                               3850 /* 0x00000f0aL */
#define PGS_F_TOOLKIT                               4363 /* 0x0000110bL */
#define PGS_E_GEO                                   3852 /* 0x00000f0cL */
#define PGS_E_DCE                                   3853 /* 0x00000f0dL */
#define PGS_E_MATH                                  3854 /* 0x00000f0eL */
#define PGS_E_ENV                                   3855 /* 0x00000f0fL */

/*
 * Defined constants with seed = 2 (SMF code)
 */
#define PGSSMF_E_UNDEFINED_CODE                    19968 /* 0x00004e00L */
#define PGSSMF_E_UNDEFINED_UNIXERRNO               19969 /* 0x00004e01L */
#define PGSSMF_E_CANT_OPEN_FILE                    19970 /* 0x00004e02L */
#define PGSSMF_E_MSG_TOOLONG                       19971 /* 0x00004e03L */
#define PGSSMF_E_SIGFPE                            19972 /* 0x00004e04L */
#define PGSSMF_E_SIGACTION                         19973 /* 0x00004e05L */
#define PGSSMF_E_INVALID_FORMAT                    19974 /* 0x00004e06L */
#define PGSSMF_E_BAD_REFERENCE                     19975 /* 0x00004e07L */
#define PGSSMF_E_INVALID_FILE                      19976 /* 0x00004e08L */
#define PGSSMF_E_SENDFILE                          19977 /* 0x00004e09L */
#define PGSSMF_E_NOMAIL_ADDR                       19978 /* 0x00004e0aL */
#define PGSSMF_E_NONETRC_FILE                      19979 /* 0x00004e0bL */
#define PGSSMF_E_NETRC_MODE                        19980 /* 0x00004e0cL */
#define PGSSMF_E_SENDMAIL                          19981 /* 0x00004e0dL */
#define PGSSMF_E_REMOTEPATH                        19982 /* 0x00004e0eL */
#define PGSSMF_E_NOHOSTNAME                        19983 /* 0x00004e0fL */
#define PGSSMF_E_LOGFILE                           19984 /* 0x00004e10L */
#define PGSSMF_E_SENDRUNTIME_DATA                  19985 /* 0x00004e11L */
#define PGSSMF_E_SENDSTATUS_LOG                    19986 /* 0x00004e12L */

#define PGSSMF_W_NOACTION                          19475 /* 0x00004c13L */
#define PGSSMF_W_SENDRUNTIME_DATA                  19476 /* 0x00004c14L */
#define PGSSMF_W_NO_CONSTRUCT_TAG                  19477 /* 0x00004c15L */
#define PGSSMF_W_NO_MESSAGE_FILE                   19478 /* 0x00004c16L */

#define PGSSMF_M_TRANSMIT_DISABLE                  17942 /* 0x00004616L */
#define PGSSMF_M_UNIX                              17943 /* 0x00004617L */
#define PGSSMF_M_NOT_IN_CACHE                      17944 /* 0x00004618L */
 
/*
 * SMF Limitations 
 */
#define PGS_SMF_MAX_SEED_NO            524287   /* 2^19 - 1; 19 bits                */
#define PGS_SMF_MAX_MNEMONIC           510      /* 2^9 - 1; 9 bits                  */
#define PGS_SMF_MAX_INSTR_SIZE         11       /* max. 10 chars, 1 char for '\0'   */           
#define PGS_SMF_MAX_LABEL_SIZE         11       /* max. 10 chars, 1 char for '\0'   */
#define PGS_SMF_MAX_MNEMONIC_SIZE      32       /* instr_size + _ + SH + _ + 17, 1 char for '\0'     */
#define PGS_SMF_MAX_MSG_SIZE           241      /* max. 240 chars, 1 char for '\0'  */
#define PGS_SMF_MAX_ACT_SIZE           241      /* max. 240 chars, 1 char for '\0'  */
#define PGS_SMF_MAX_MSGBUF_SIZE        481      /* max. 480 chars, 1 char for '\0'  */
#define PGS_SMF_MAX_FUNC_SIZE          101      /* max. 100 chars, 1 char for '\0'  */
#define PGS_SMF_MAX_MSGTAG_SIZE        61       /* max. 60 chars, 1 char for '\0'   */

/*
 * SMF Status Level 
 */
#define PGS_SMF_STAT_LEV_SH            "_SH_"
#define PGS_SMF_STAT_LEV_M             "_M_"
#define PGS_SMF_STAT_LEV_U             "_U_"
#define PGS_SMF_STAT_LEV_S             "_S_"
#define PGS_SMF_STAT_LEV_N             "_N_"
#define PGS_SMF_STAT_LEV_W             "_W_"
#define PGS_SMF_STAT_LEV_F             "_F_"
#define PGS_SMF_STAT_LEV_E             "_E_"
#define PGS_SMF_STAT_LEV_A             "_A_"

#define PGS_SMF_MASK_LEV_SH            0x00000000L      /* _SH_ : shell     */
#define PGS_SMF_MASK_LEV_S             0x00000200L      /* _S_  : success   */
#define PGS_SMF_MASK_LEV_A             0x00000400L      /* _A_  : action    */
#define PGS_SMF_MASK_LEV_M             0x00000600L      /* _M_  : message   */
#define PGS_SMF_MASK_LEV_U             0x00000800L      /* _U_  : user info */
#define PGS_SMF_MASK_LEV_N             0x00000a00L      /* _N_  : notice    */
#define PGS_SMF_MASK_LEV_W             0x00000c00L      /* _W_  : warning   */
#define PGS_SMF_MASK_LEV_E             0x00000e00L      /* _E_  : error     */
#define PGS_SMF_MASK_LEV_F             0x00001000L      /* _F_  : fatal     */

#define PGS_SMF_MASK_CONSTANT          0x000001ffL      /* Bit: 8  - 0  */
#define PGS_SMF_MASK_LEVEL             0x00001e00L      /* Bit: 12 - 9  */
#define PGS_SMF_MASK_SEED              0xffffe000L      /* Bit: 31 - 13 */


/*
 * SMF System Info
 */
#define PGS_SMF_SYS_FILEPREFIX     "PGS"         
#define PGS_SMF_SYS_INSTR          "PGSTK"            
#define PGS_SMF_SYS_LABEL          "PGS" 
#define PGS_SMF_SYS_SEED           0            

#define PGS_SMF_ASSIGN_LABEL       "PGSSMF"            
#define PGS_SMF_ASSIGN_SEED        2            


/*
 * Command Definitions Used By PGS_SMF_CacheMsgShm
 */
#define PGSd_SMF_FindByCode        1
#define PGSd_SMF_FindByMnemonic    2
#define PGSd_SMF_AddRecord         3
#define PGSd_SMF_LastFindStatus    4
#define PGSd_SMF_DisplayBuffer     5
#define PGSd_SMF_InitCacheInfo1    6
#define PGSd_SMF_InitCacheInfo2    7


/*
 * Definitions Used By PGS_SMF_MsgLevel
 */
#define PGSd_SMF_IncLevel          1    /* command */
#define PGSd_SMF_DecLevel          2    /* command */
#define PGSd_SMF_GetLevel          3    /* command */
#define PGSd_SMF_SetIndentString   4    /* command */
#define PGSd_SMF_EnableLevel       5    /* command */
#define PGSd_SMF_DisableLevel      6    /* command */

#define PGSd_SMF_MaxMsgLevel      20    /* max value */
 
/*
 * Structure Defintions
 */ 
typedef struct
{
    PGSt_SMF_code           seed;                                   /* unique seed no  */
    char                    instr[PGS_SMF_MAX_INSTR_SIZE];          /* organization    */
    char                    label[PGS_SMF_MAX_LABEL_SIZE];          /* instrument name */
}PGS_SMF_FileInfo;

typedef struct 
{
    PGSt_SMF_code           code;                                    /* unique code              */
    char                    mnemonic[PGS_SMF_MAX_MNEMONIC_SIZE];     /* mnemonic label           */
    char                    msg[PGS_SMF_MAX_MSG_SIZE];               /* mnemonic message string  */
    char                    action[PGS_SMF_MAX_MNEMONIC_SIZE];       /* action label             */
}PGS_SMF_MsgData;
                         
typedef struct
{
    PGSt_SMF_code           seed;                /* max unique seed (19 bits)  */ 
    short                   levels;              /* max levels (4 bits)        */
    short                   unique_code;         /* max unique code (9 bits)   */
}PGS_SMF_CodeInfo;

typedef struct                                  
{                                       
    PGS_SMF_FileInfo        fileinfo;
    PGS_SMF_MsgData         msgdata;
    char                    funcname[PGS_SMF_MAX_FUNC_SIZE];
}PGS_SMF_MsgInfo;

typedef struct
{
    void (*func)(int signo);                              /* signal handler */
    char funcname[PGS_SMF_MAX_FUNC_SIZE];                 /* function name */
}PGSSmfSigHandler;

typedef struct
{
    char               logStatus[PGSd_SMF_PATH_MAX];       /* status log file */
    char               logReport[PGSd_SMF_PATH_MAX];       /* report log file */
    char               logUser[PGSd_SMF_PATH_MAX];         /* user log file */ 
    FILE              *fptrStatus;                         /* status log file pointer */
    FILE              *fptrReport;                         /* report log file pointer */
    FILE              *fptrUser;                           /* user log file pointer */
    char               msgTag[PGSd_SMF_TAG_LENGTH_MAX];    /* message tag */   
    PGSt_SMF_boolean   record;                             /* flag to indicate if errors are to be captured into log files */
    PGSt_SMF_boolean   transmit;                           /* flag to indicate if allow to send the log files */    
}PGSSmfLog;

typedef struct
{
    PGSt_SMF_boolean   transmit;            /* flag to indicate if allow to send the files */
}PGSSmfRunData;

typedef struct
{
    PGSt_SMF_code     fileNo[PGSd_SMF_NUM_OPENFILE];     /* file number */
    FILE             *filePtr[PGSd_SMF_NUM_OPENFILE];    /* opened file pointer */
    int               num;                               /* number of file opened */
}PGSSmfOpenFile;

/*
 *  Former Static Global Variables
 */

typedef struct
{
    PGSt_SMF_status    callerID;            /* callerID to stop cyclic situation */
    PGSt_SMF_status    writeLogFile;        /* flag to capture errors to log file */
    PGSt_SMF_status    useMemType;          /* flag to use either shared memory or ascii file */
    PGSt_SMF_status    whichProc;           /* which process are we in? (init., PGE, or term.) */
}PGSSmfOtherGlb;

typedef struct                     /* message cache: indices, record count */
{                                       
    PGSt_integer            newest;        /* index to newest entry */
    PGSt_integer            oldest;        /* index to oldest entry */
    PGSt_uinteger            count;        /* count of records allocated */
}PGS_SMF_MsgCacheInfo;

/*
 *  SMF Global Variable Data Structure
 */

typedef struct
{
    PGS_SMF_MsgInfo   msginfo;                      /* code buffer */
    char              msg[PGS_SMF_MAX_MSGBUF_SIZE]; /* current message buffer */
    PGSSmfSigHandler  signal;                       /* signal handling */
    PGSSmfLog         log;                          /* log files */
    PGSSmfRunData     rundata;                      /* runtime files */
    PGSSmfOpenFile    open;                         /* opened files */
    PGS_SMF_MsgCacheInfo msgCacheInfo;              /* message cache info */
    PGSSmfOtherGlb    other;                        /* other globals */
    PGSt_SMF_code     unixErrno;                    /* Unix errno */
}PGSSmfGlbVar;


/*
 *  Shared Memory Data Structure
 */

typedef struct
{
    char  logStatus[PGSd_SMF_PATH_MAX];      /* status log file */
    char  logReport[PGSd_SMF_PATH_MAX];      /* report log file */
    char  logUser[PGSd_SMF_PATH_MAX];        /* user log file */ 
    char  msgTag[PGSd_SMF_TAG_LENGTH_MAX];   /* message tag */  
    int   writeLogFile;                      /* write to log file */
    PGS_SMF_MsgCacheInfo msgCacheInfo;       /* message cache info */
}PGSSmfShm;


/*
 * PGS_SMF.c: External Functions 
 */
extern PGSt_SMF_status       PGS_SMF_SetHDFMsg             (PGSt_SMF_code code,char *msg,char *funcname);       
extern PGSt_SMF_status       PGS_SMF_SetUNIXMsg            (PGSt_integer unix_errcode,char *msg,char *funcname);
extern PGSt_SMF_status       PGS_SMF_SetStaticMsg          (PGSt_SMF_code code,char *funcname);
extern PGSt_SMF_status       PGS_SMF_SetDynamicMsg         (PGSt_SMF_code code,char *msg,char *funcname);
extern PGSt_SMF_status       PGS_SMF_GetActionByCode       (PGSt_SMF_code code,char action[]);
extern PGSt_SMF_status       PGS_SMF_GetMsgByCode          (PGSt_SMF_code code,char msg[]);
extern void                  PGS_SMF_GetMsg                (PGSt_SMF_code *code,char mnemonic[],char msg[]);
extern PGSt_SMF_status       PGS_SMF_CreateMsgTag          (char *systemTag);
extern PGSt_SMF_status       PGS_SMF_GetInstrName          (PGSt_SMF_code code,char instr[]);
extern PGSt_SMF_status       PGS_SMF_GenerateStatusReport  (char *report);
extern PGSt_SMF_boolean      PGS_SMF_TestErrorLevel        (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestFatalLevel        (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestMessageLevel      (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestWarningLevel      (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestUserInfoLevel     (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestSuccessLevel      (PGSt_SMF_status code);
extern PGSt_SMF_boolean      PGS_SMF_TestNoticeLevel       (PGSt_SMF_status code);
extern PGSt_SMF_status       PGS_SMF_TestStatusLevel       (PGSt_SMF_status code);
extern PGSt_SMF_status       PGS_SMF_GetGlobalVar          (PGSSmfGlbVar **global_var);
extern void                  PGS_SMF_GetSystemCode         (PGSt_SMF_code code,char *mnemonic,char *msg);
extern void                  PGS_SMF_GetSMFCode            (PGSt_SMF_code code,char *mnemonic,char *msg);
extern void                  PGS_SMF_ExtractMsgInfo        (PGS_SMF_MsgInfo *codeinfo,char *line);
extern void                  PGS_SMF_ExtractFileInfo       (PGS_SMF_MsgInfo *codeinfo,char *line);
extern PGSt_SMF_status       PGS_SMF_GetEnv                (PGS_SMF_MsgInfo *codeinfo,char *funcname);
extern PGSt_SMF_status       PGS_SMF_CallerID              (void);
extern PGSt_SMF_status       PGS_SMF_Get_WriteLogFile      (void);
extern PGSt_SMF_status       PGS_SMF_DecodeCode            (PGSt_SMF_code code,char *mnemonic,PGS_SMF_MsgInfo *codeinfo,char *func,short op);
extern PGSt_SMF_status       PGS_SMF_GetSysShm             (PGSSmfGlbVar *global_var);
extern void                  PGS_SMF_InitProc              (PGSt_SMF_status useMem,PGSt_SMF_status writeLog);
extern void                  PGS_SMF_TermProc              (PGSt_SMF_status useMem,PGSt_SMF_status writeLog);
extern void                  PGS_SMF_TermSMF               (void);
extern PGSt_SMF_status       PGS_SMF_Begin                 (char *);
extern PGSt_SMF_status       PGS_SMF_End                   (char *);

/*
 * PGS_SMF_Util.c: External Functions
 */
extern PGSt_SMF_status       PGS_SMF_PrintFile             (char *file);
extern PGSt_SMF_status       PGS_SMF_SetRunTimeData_Int    (char msg[],PGSt_integer value);
extern PGSt_SMF_status       PGS_SMF_SetRunTimeData_Short  (char msg[],short value);
extern PGSt_SMF_status       PGS_SMF_SetRunTimeData_Double (char msg[],PGSt_double value);
extern PGSt_SMF_status       PGS_SMF_SetRunTimeData_Float  (char msg[],float value);
extern void                  PGS_SMF_PrintMsgInfo          (PGS_SMF_MsgInfo *msginfo);
extern PGSt_SMF_status       PGS_SMF_SetArithmeticTrap     (void (*func)(int signo));
extern void                  PGS_SMF_SysSignalHandler      (int signo);
extern PGSt_SMF_status       PGS_SMF_Sigaction             (void (*func)(int signo),char *funcname);

/*
 * PGS_SMF_Comm.c: External Functions
 */
extern PGSt_SMF_status       PGS_SMF_System                (char *cmdStr);
extern PGSt_SMF_status       PGS_SMF_SendFile              (char *LocalFileName,char *RemoteHostName,char *RemoteFileName);  
extern PGSt_SMF_status       PGS_SMF_SendMail              (char *toAddresses,char *ccAddresses,char *bccAddresses,char *subText,char *msgText);
extern PGSt_SMF_status       PGS_SMF_CheckNetrcFile        (char *RemoteHostName);
extern void                  PGS_SMF_RemoveSpace           (char *str);

/*
 * PGS_SMF_SendStatusReport.c: External Functions
 */
extern PGSt_SMF_status       PGS_SMF_SendStatusReport        (void);
extern PGSt_SMF_status       PGS_SMF_SysSendStatusReport     (void);
extern PGSt_SMF_status       PGS_SMF_SysTermSendStatusReport (void);

/*
 * PGS_SMF_SendRuntimeData.c: External Functions
 */
extern PGSt_SMF_status       PGS_SMF_SendRuntimeData         (PGSt_integer numfiles,PGSt_PC_Logical files[],PGSt_integer version[]);
extern PGSt_SMF_status       PGS_SMF_SysSendRuntimeData      (void);
extern PGSt_SMF_status       PGS_SMF_SysTermSendRuntimeData  (void);

/*
 * PGS_SMF_Popen.c: External Functions
 */
extern FILE*                 PGS_SMF_Popen                 (const char *cmdStr,const char *type);
extern int                   PGS_SMF_Pclose                (FILE *fp);
extern int                   PGS_SMF_OpenMax               (void);

/*
 * PGS_SMF1.c: External Functions
 */
extern void                  PGS_SMF_SetUnknownMsg         (PGSt_SMF_status code,char *funcname);



#ifdef __cplusplus
}
#endif

#endif /* end _PGS_SMF_H */

