/*******************************************************************************
BEGIN_FILE_PROLOG:

NAME:
   PGS_TD.h

DESCRIPTION:
   This file contains the typedefs, special defines, include files, and function
   prototypes for the SDP (aka PGS) Toolkit Time and Date Tools.

END_FILE_PROLOG:
*******************************************************************************/

#ifndef _PGS_TD_H_
#define _PGS_TD_H_

/*  include files  */

#include <PGS_SMF.h>
#include <PGS_CSC_4.h>

/* error messages */

#include <PGS_TD_3.h>

/*  spacecraft ID flags  */

#define PGSd_EOS_AM        2222       
#define PGSd_EOS_PM        3333
#define PGSd_TRMM          4444

/* geolocation "bad data" value */

#define PGSd_GEO_ERROR_VALUE 1.0E50
#define PGS_GEO_ERROR_VALUE 1.0E50 /* for backward compatibility */

/* special data types */

typedef PGSt_integer PGSt_flag;

/* old typedefs for backward compatibility */

typedef unsigned char PGSt_sc_timeType;
typedef unsigned char PGSt_scTime;      /* this is still in toolkit code */

/*     Function prototypes    */

extern PGSt_SMF_status
PGS_TD_SCtime_to_UTC(PGSt_tag, PGSt_scTime [][8], PGSt_integer, char*,
		     PGSt_double []); 

extern PGSt_SMF_status
PGS_TD_UTCtoTAIjd(char*, PGSt_double [2]);    

extern PGSt_SMF_status
PGS_TD_UTCtoTDTjed(char*, PGSt_double [2]);    

extern PGSt_SMF_status
PGS_TD_UTCtoTDBjed(char*, PGSt_double [2]);    

extern PGSt_double
PGS_TD_gmst(PGSt_double [2]);

extern PGSt_double
PGS_TD_gast(PGSt_double, PGSt_double, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_timeCheck(char*);

extern PGSt_SMF_status
PGS_TD_UTCtoUTCjd(char*, PGSt_double [2]); 
    
extern PGSt_SMF_status
PGS_TD_LeapSec(PGSt_double [2], PGSt_double*, PGSt_double*, PGSt_double*,
	       char [10]);
 
extern PGSt_integer
PGS_TD_julday(PGSt_integer, PGSt_integer, PGSt_integer);

extern void
PGS_TD_calday(PGSt_integer, PGSt_integer*, PGSt_integer*, PGSt_integer*);

extern PGSt_SMF_status
PGS_TD_UTCtoTAI(char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_TAItoUT1jd(PGSt_double, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_TAItoUT1pole(PGSt_double, PGSt_double [2], PGSt_double*, PGSt_double*,
		    PGSt_double*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_TAItoUTC(PGSt_double, char*);

extern PGSt_SMF_status
PGS_TD_TAItoUTCjd(PGSt_double, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_TAItoGAST(PGSt_double, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_EOSAMtoUTC(unsigned char*, char*);

extern PGSt_SMF_status
PGS_TD_EOSPMtoUTC(unsigned char*, char*);

extern PGSt_SMF_status
PGS_TD_TRMMtoUTC(unsigned char*, char*);

extern PGSt_SMF_status
PGS_TD_EOSAMtoTAI(unsigned char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_EOSPMtoTAI(unsigned char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_TRMMtoTAI(unsigned char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_UTC_to_SCtime(PGSt_tag, char*, unsigned char*);

extern PGSt_SMF_status
PGS_TD_UTCtoEOSAM(char*, unsigned char*);

extern PGSt_SMF_status
PGS_TD_UTCtoEOSPM(char*, unsigned char*);

extern PGSt_SMF_status
PGS_TD_TAItoTRMM(PGSt_double, unsigned char*);

extern PGSt_SMF_status
PGS_TD_SCtoTAI(PGSt_scTime [9], PGSt_double*);

extern PGSt_SMF_status
PGS_TD_UTCtoTRMM(char*, unsigned char*);

extern PGSt_SMF_status
PGS_TD_ASCIItime_AtoB(char*, char*);

extern PGSt_SMF_status
PGS_TD_ASCIItime_BtoA(char*, char*);

extern PGSt_SMF_status
PGS_TD_GPStoUTC(PGSt_double, char*);

extern PGSt_SMF_status
PGS_TD_UTCtoGPS(char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_TimeInterval(PGSt_double, PGSt_double, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_UTCtoUT1(char*, PGSt_double*);

extern PGSt_SMF_status
PGS_TD_UTCtoUT1jd(char*, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_sortArrayIndices(PGSt_double [], PGSt_integer, PGSt_integer []);

extern PGSt_double *
PGS_TD_JulianDateSplit(PGSt_double [2], PGSt_double [2]);

extern PGSt_double
PGS_TD_TAIjdtoTAI(PGSt_double [2]);

extern PGSt_double *
PGS_TD_TAIjdtoTDTjed(PGSt_double [2], PGSt_double [2]);

extern PGSt_double *
PGS_TD_TDTjedtoTAIjd(PGSt_double [2], PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_TAIjdtoUTCjd(PGSt_double [2], PGSt_double [2]);

extern PGSt_double *
PGS_TD_TAItoTAIjd(PGSt_double, PGSt_double [2]);

extern PGSt_double *
PGS_TD_TDTjedtoTDBjed(PGSt_double [2], PGSt_double [2]);

extern PGSt_double *
PGS_TD_TDBjedtoTDTjed(PGSt_double [2], PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_UTCjdtoTAIjd(PGSt_double [2], PGSt_boolean, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_UTCjdtoUT1jd(PGSt_double [2], PGSt_boolean, PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_UTCjdtoUTC(PGSt_double [2], PGSt_boolean, char*);

extern PGSt_double *
PGS_TD_JDtoMJD(PGSt_double [2], PGSt_double [2]);

extern PGSt_double *
PGS_TD_MJDtoJD(PGSt_double [2], PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_PB5toUTCjd(PGSt_scTime [9], PGSt_double [2]);

extern PGSt_SMF_status
PGS_TD_UTCjdtoPB5(PGSt_double [2], PGSt_boolean, PGSt_scTime [9]);

extern  PGSt_SMF_status 
PGS_TD_PB5toTAI(PGSt_scTime [9], PGSt_double*);

#endif
