/*--------------------
 *
 * example usage:
 * PGSt_SMF_status returnStatus;
 * char epoch[100];
 *
 * returnValue = PGS_TD_EpochDayStr("TRMM", epoch);
 *
 * reads $PPSFILES/satepoch.dat; copies  epoch day (in format A) to epoch
 * 
 * the format for the satepoch.dat file is 
 * <epoch id>=<epoch day in format A or B>
 * for example
 * TRMM=1993-01-01T00:00:00.000000Z
 * 
 * RETURNS:
 * 	PGS_S_SUCCESS
 *	PGSSMF_E_CANT_OPEN_FILE  (either setepoch.dat is missing or unreadable)
 *      PGSSMF_E_CANT_GET_EPOCH  (can't find eochId in satepoch.dat)
 *      PGSTD_E_TIME_VALUE_ERROR 
 *      PGSTD_E_TIME_FMT_ERROR
 *	PGS_E_TOOLKIT            (something is wrong with the toolkit)
 *
 * Created: July 2010
 * @author: John Bonk
 * Revised: $Author: hensley $ revised on $Date: 2011/04/08 01:35:49 $
 * @version $Revision: 1.1.1.1 $
 *------------------*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <PGS_TD.h>
#include <PGS_SMF.h>
#include <PGS_PC_9.h>

#define ARRAYSIZE    200
#define MAX_MSG_SIZE 241
#define TK_PATHLEN      200
#define DELIMINATER  '='

PGSt_SMF_status  
PGS_TD_EpochDayStr(char* epochId,       /* id of epoch--'TRMM', 'GPS', etc */
                   char epoch[]         /* epoch will be copied here */
                  )
{
    PGSt_SMF_status returnValue = PGS_S_SUCCESS;
    static int fileRead = PGS_FALSE;      /* was satepoch.dat read? */
    int found = PGS_FALSE;
    char line[MAX_MSG_SIZE];
    static char epochs[ARRAYSIZE][MAX_MSG_SIZE];
    char *searchStr;
    char epochTmp[FORMAT_A_SIZE];      /* temporarily holds the format A
                                          value if we need to convert from
                                          format B to format A */
    char                *path;
    char                fullpath[TK_PATHLEN];
    char *cPtr1, *cPtr2;

    FILE                *fp;
    int i;  /* just a counter */
    static int recordsRead;

    if (strncmp(epochId, "JulianEpoch", strlen("JulianEpoch")) == 0)
    {
    	strcpy(epoch, "01-Jan-4713BC-T12:00:00.0Z");
    	return returnValue;
    }


    if (fileRead == PGS_FALSE) {
          /* Open the satepoch file for reading */
        path = getenv("PPSFILES");
        if (path == NULL)
            return PGSSMF_E_CANT_OPEN_FILE;

        strcpy(fullpath, path);
        strcat(fullpath, "/satepoch.dat");

        fp = fopen(fullpath, "r");
        if (fp == NULL) {
            return PGSSMF_E_CANT_OPEN_FILE;
        }
        
        recordsRead = 0;
        i = 0;
        while (fgets(line, MAX_MSG_SIZE,fp))
        {
            /* lets allow comments in the satepoch file */
            if (line[0] == '#') continue;
            strncpy(epochs[i], line, MAX_MSG_SIZE);
            i++;
            recordsRead++;
        }
        fclose(fp);
        fileRead = PGS_TRUE;

    }  /* end if (fileRead) */
    
    if (recordsRead == 0) 
    {
       return PGSPC_E_FILE_READ_ERROR;
    }
    /* we want to include the '=' in the search because without it 
       a search for, say, 'str1' could return 'str10'
     */
    searchStr = (char*) malloc( strlen(epochId) );
    strcpy(searchStr, epochId);
    strcat(searchStr, "=");
  

    for (i=0; i<recordsRead; i++) {
        if (cPtr1 = strstr(epochs[i], epochId)) {
            cPtr2 = strchr(epochs[i], '=');
            /* why are we checking lengths?  For the same reason we 
               included the '=' in the search, we don't want a search
               for 'str1' to return 'another_str1'
             */
            if ( (cPtr2) && 
                ( (cPtr2 - cPtr1) == strlen(epochId)) )
            {
                strncpy(epoch, ++cPtr2, FORMAT_A_SIZE); 
                epoch[FORMAT_A_SIZE - 1] = '\0';
                found = PGS_TRUE;
                break;
            }
        }
    } 
    free(searchStr);
    
    /* if we found a matching epoch, we need to test if, and reformat it
       if needed
     */
    if (found) 
    {
        returnValue = PGS_TD_timeCheck(epoch);
        if (returnValue != PGS_S_SUCCESS)
        {
            if (returnValue == PGSTD_M_ASCII_TIME_FMT_B)
            {
                returnValue = PGS_TD_ASCIItime_BtoA(epochTmp, epoch); 
                if (returnValue == PGS_S_SUCCESS )
                {
                    strcpy(epoch, epochTmp); 
                }
            } 
        } 
    }
    else returnValue = PGSSMF_E_CANT_GET_EPOCH;

    return returnValue;
}
