/*--------------------
 * sample usage:
 * PGSt_SMF_status returnStatus;
 * PGSt_double epoch[2];
 *
 * returnValue = PGS_TD_EpochDayjd("TRMM", epoch);
 * 
 * reads $PPSFILES/satepoch.dat; and copies epoch day and day fraction 
 * to epoch for a specified string.
 *
 * RETURNS:
 *      PGS_S_SUCCESS
 *      PGSSMF_E_CANT_OPEN_FILE  (either setepoch.dat is missing or unreadable)
 *      PGSSMF_E_CANT_GET_EPOCH  (can't find eochId in satepoch.dat)
 *      PGSTD_E_TIME_VALUE_ERROR 
 *      PGSTD_E_TIME_FMT_ERROR
 *      PGSTD_M_LEAP_SEC_IGNORED
 *      PGS_E_TOOLKIT            (something is wrong with the toolkit)
 *
 *
 * Created: July 2010
 * @author: John Bonk
 * Revised: $Author: hensley $ revised on $Date: 2011/04/08 01:35:49 $
 * @version $Revision: 1.1.1.1 $
 *------------------*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <PGS_TD.h>
#include <PGS_SMF.h>
#include <PGS_PC_9.h>


PGSt_SMF_status  
PGS_TD_EpochDayjd(char* epochId,       /* id of epoch--'TRMM', 'GPS', etc */
                PGSt_double jdEpoch[2]      /* epoch will be copied here */
               )
{
    PGSt_SMF_status returnValue = PGS_S_SUCCESS;
    char epoch[FORMAT_A_SIZE];

    if (strncmp(epochId, "JulianEpoch", strlen("JulianEpoch")) == 0)
    {
    	jdEpoch[0] = 0.0;
    	jdEpoch[1] = 0.0;
    	return returnValue;
    }

    returnValue = PGS_TD_EpochDayStr(epochId, epoch);
    if (returnValue == PGS_S_SUCCESS) {
        returnValue = PGS_TD_UTCtoUTCjd(epoch, jdEpoch);
    }

    return returnValue;    
}
