/*--------------------
 * convert gps week and seconds to  TAI seconds
 * Created: July 2010
 * @author: John Bonk
 * Revised: $Author: hensley $ revised on $Date: 2011/04/08 01:35:49 $
 * @version $Revision: 1.1.1.1 $
 *
 * Converts GPS time--cycle, week, seconds--to TAI seconds.
 *------------------*/


#include <PGS_TD.h>
#include <PGS_SMF.h>

#define SECONDS_IN_WEEK 604800.0  /* 86400 * 7 */
#define SECONDS_IN_DAY 86400.0


PGSt_SMF_status PGS_TD_GPSwktoTAI(long cycle,   /* (total weeks)/1024 */
                                  long week,    /* (total weeks)%1024 */
                                  PGSt_double seconds, /* second in GPS week */ 
                                  PGSt_double *secondsTAI)
{
    PGSt_SMF_status returnStatus = PGS_S_SUCCESS;
    long gpsWeeks;   /* this will be (cycle * 1024) + weeks */

    if ((cycle < 0) || week < 0) 
    {
        return PGSTD_E_TIME_VALUE_ERROR;
    }

    if ((seconds < 0) || (seconds >= SECONDS_IN_WEEK)) 
    {
        return PGSTD_E_TIME_VALUE_ERROR;
    }
 
    
    /* to get TAI seconds multiply to the number of days in the total gps weeks 
       (1024 times the week cycle plus the value in the 'week' variable) by 7, 
       then add the epoch day fraction, and multiply the whole thing by the
       number of seconds in a day (86400) then add leapseconds for epoch
     */ 
    gpsWeeks = (cycle * 1024) + week;
    *secondsTAI = ((gpsWeeks * 7) * SECONDS_IN_DAY)
                   + seconds; 

    return returnStatus;     
}


