#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "TS_GLOBAL.h"

#define PREDCHAR     10
#define ARRAYSIZE    200
#define MAX_MSG_SIZE 241
#define W_PGS_CLOSEFAIL 100
#define W_PGS_OPENFAIL  101
#define TK_PATHLEN      200

int PGS_TD_LeapSec(                       /* Get Leap Second */
    double jdUTC[2],                      /* UTC Julian Date */
    double *leapSec,                      /* requested leap second value */
    double *lastChangeJD,                 /* Julian Day number on which
					     output leap second was
					     effective */
    double *nextChangeJD,                 /* Julian Day number on which
					     next leap second change
					     occurred (or is predicted to
					     occur) */
    char   leapStatus[PREDCHAR])          /* indicates whether the leap sec
					     value is actual, predicted or
					     computed using a linear fit */
{	   
  double              jdUTCadd;
  static double       jd[ARRAYSIZE];
/*  static double       jdfirst; */
  static double       jdlast;

  static float        leapseconds[ARRAYSIZE];
  static float        slope[ARRAYSIZE];
  static float        baseDay[ARRAYSIZE];

  unsigned int        numrecs;
  int                 recordread;

  static unsigned int cntr=1;
  char                msg[MAX_MSG_SIZE];
  char                predict[ARRAYSIZE][PREDCHAR];
  char                *path;
  char                fullpath[TK_PATHLEN];

  FILE                *fp;

  /* Express jdUTC as a single number */
  jdUTCadd = jdUTC[0] + jdUTC[1];

  /* Open the leapsecond file for reading */
  path = getenv("PPSFILES");
  if (path == NULL)
    return W_PGS_OPENFAIL;

  strcpy(fullpath, path);
  strcat(fullpath, "/leapsec.dat");

  fp = fopen(fullpath, "r");
  if (fp == NULL) {
    return W_PGS_OPENFAIL;
  }

  /* Read leap second file and load into arrays in memory until the end of  
   * file is encountered, skipping unwanted characters
   */	 

  /* initialize record counter to zero */
	
  numrecs = 0; 
	
  /* Read header line - ignore (recycle the msg variable which is no
   * longer needed at this point) 
   */

  fgets(msg,MAX_MSG_SIZE,fp);

  /*  Read first data line */
	
  recordread = fscanf(fp, "%*d %*s %*d %*s %lf %*s %f %*s %*s %*s %*s"
		      "%f%*s %*s %f %*s %s", &jd[numrecs],
		      &leapseconds[numrecs],&baseDay[numrecs],
		      &slope[numrecs],predict[numrecs]);
	
  /*  Read Remainder  */
	
  while (recordread != EOF)              /** RECORD READ ** WHILE START */
    {
      numrecs++;
      recordread = fscanf(fp, "%*d %*s %*d %*s %lf %*s %f %*s %*s %*s"
			  "%*s %f%*s %*s %f %*s %s", &jd[numrecs],
			  &leapseconds[numrecs], &baseDay[numrecs],
			  &slope[numrecs],predict[numrecs]);
    }                                      /** RECORD READ ** WHILE END */ 
	
  /* jdfirst = jd[0]; */        /* first Julian Day number in the table */
  jdlast = jd[numrecs-1];  /* last Julian Day number in the table */

  /* close file */

  if ( fclose( fp ) == EOF ) {
    return W_PGS_CLOSEFAIL;
  }

  /* SEARCH through arrays to find desired Julian Day number and leap
     seconds value */
    
  /* If the input Julian day is within the range of the table -- output it.
     Allow a leeway at the upper end, assuming no more leap seconds for 365
     days */
    
  /* Search through the table and find the appropriate time.  The variable
   * cntr is static, search for the time using the most recent value of
   * cntr.  This optimizes for the case that the times input (in
   * successive calls to this function) are near one another (seems pretty
   * likely).
   */

  if (jdUTCadd < (double) jd[cntr-1])
    while ( jdUTCadd < (double) jd[cntr-1] ) 
      cntr--; 
  else
    while ( (cntr < numrecs) && (jdUTCadd >= (double) jd[cntr]) )
      cntr++; 
  
  if (slope[cntr-1] == 0.0F)
    *leapSec = (double) leapseconds[cntr-1];
  else
    *leapSec = (double) (leapseconds[cntr-1] + slope[cntr-1]*
			 (jdUTCadd - 2400000.5 - baseDay[cntr-1]));
  *lastChangeJD = (double) jd[cntr-1];
  
  if (cntr < numrecs)
    *nextChangeJD = (double) jd[cntr];
  else
    *nextChangeJD = (double) (jdlast + 365.0);
	
  strncpy(leapStatus,predict[cntr-1],PREDCHAR);

  return TS_SUCCESS;
} 
