/*******************************************************************************
FILENAME:   
   PGS_TD_SCtoTAI.c

DESCRIPTION:

   This function converts spacecraft clock time in CCSDS Unsegmented Time
   Code (CUC) to TAI (Toolkit internal time). 

   This function is for the orbit boundary time convertion in 
   PPS(little-endian machine) only. 
 
AUTHOR:
   Yong Zhang

HISTORY:
   09-Feb-2007   Initial version
*******************************************************************************/

#include <string.h>
#include <PGS_TD.h>

PGSt_SMF_status PGS_TD_SCtoTAI(PGSt_scTime scTime[8], PGSt_double *secTAI)    
{

    PGSt_uinteger seconds;        /* decimal number of s/c clock seconds */
    PGSt_uinteger subSeconds;     /* decimal number of s/c clock sub-seconds */
   
    memcpy(&seconds, scTime, 4);
    memcpy(&subSeconds, scTime+4, 4);

    *secTAI = (PGSt_double)seconds + (PGSt_double)subSeconds/4294967296.0;
    
    return PGS_S_SUCCESS;     

}
