/*--------------------
 * convert TAI seconds to gps week and seconds
 * Created: July 2010
 * @author: John Bonk
 * Revised: $Author: hensley $ revised on $Date: 2011/04/08 01:35:49 $
 * @version $Revision: 1.1.1.1 $
 *------------------*/

#include <PGS_TD.h>
#include <PGS_SMF.h>

#define SECONDS_IN_WEEK 604800.0  /* 86400 * 7 */
#define SECONDS_IN_DAY 86400.0
#define WEEKS_IN_CYCLE 1024


PGSt_SMF_status PGS_TD_TAItoGPS(PGSt_double secondsTAI,
                                int *cycle,   /* (total weeks)/1024 */
                                int *week,    /* (total weeks)%1024 */
                                PGSt_double *secondsGPS)
{
    PGSt_SMF_status returnStatus = PGS_S_SUCCESS;
    int totalWeeks;

    if (secondsTAI < 0.0) return PGSTD_E_TIME_VALUE_ERROR;

    totalWeeks = (int) (secondsTAI / SECONDS_IN_WEEK);
    *cycle = (int) totalWeeks / WEEKS_IN_CYCLE;
    *week = totalWeeks % WEEKS_IN_CYCLE;
    
    *secondsGPS = secondsTAI - (totalWeeks * SECONDS_IN_WEEK);
     
    return returnStatus;
}
