/*******************************************************************************
DESCRIPTION:
   This function converts time in second format to TRMM spacecraft clock time in 
   CCSDS Unsegmented Time Code(CUC) format.
 
AUTHOR:
   Yong Zhang 

HISTORY:
   09-Feb-2007   Initial version
*******************************************************************************/

#include <PGS_TD.h>
#include <stdio.h>
#include <string.h>
#include "TS_GLOBAL.h"

PGSt_SMF_status PGS_TD_TAItoTRMM(PGSt_double scTAI, PGSt_scTime scTime[8]) 
{

    PGSt_uinteger  	seconds;    
    PGSt_uinteger  	subSeconds;     
    char           	msg[PGS_SMF_MAX_MSG_SIZE];
    PGSt_SMF_status   	returnStatus;        

    returnStatus = PGS_S_SUCCESS;
    
    if (scTAI < 0.0 || scTAI >= 4294967296.0)
    {
	sprintf(msg,"%s%s%s","The date portion of the input time ",
		             "string is out of range for TRMM ",
	                     "(12-31-92 < date < 2-8-2129)");
	return PGSTD_E_DATE_OUT_OF_RANGE;
    }
    
    seconds = (PGSt_uinteger) scTAI;
    subSeconds = (PGSt_uinteger) ((scTAI - seconds)*4294967296. + .5);

    memcpy(scTime, &seconds, 4);
    memcpy(scTime+4, &subSeconds, 4);

    return returnStatus; 

}
