/* CVS Comment Section
 * 
 * $Log: SPA.h,v $
 * Revision 1.1.1.1  2011/12/30 02:47:49  hensley
 * First import
 *
 * 
 * Checked into sturmmitte CVS as "spacomlin" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * Revision 1.4  2011/10/19 19:52:40  hensley
 * Added include of math.h
 * 
 * Revision 1.3  2011/07/01 22:21:19  hensley
 * Changed TSDIS to PPS
 * 
 * Revision 1.2  2008/08/20 21:43:10  hensley
 * Added stdio.h, stdlib.h, and string.h includes
 * 
 * Revision 1.1.1.1  2008/08/19 21:17:02  hensley
 * First Import
 * 
 * Checked into sturmmitte CVS as "spaweb" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * Revision 1.1.1.1  2008/06/18 23:06:08  hensley
 * Baseline PPS-- Code
 * 
 * Linux CVS Comments When Imported as "spa" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * SGI CVS Comments vvv
 * 
 * Revision 1.6  2006/12/01 03:41:09  hensley
 * Fixed CVS Comment Section
 * 
 * Revision 1.5  1997/08/01 17:38:46  piper
 * Removed nested comment.
 * 
 * Revision 1.4  1997/03/26 08:19:26  bilanow
 * Refined default parameters and widened tolerances.
 * 
 * Revision 1.3  1996/11/21  22:33:27  bilanow
 * typo fixed.
 * 
 * Revision 1.2  1996/11/20  23:59:23  bilanow
 * Added tolerences from default values, and other
 * constants, and reorganized constants according
 * to new usage with new routine.  Expanded some
 * descriptions.
 * 
 * Revision 1.1  1996/11/14  18:50:20  dbazell
 * added new files
 * 
 * Revision 1.1  1996/09/20  19:35:43  bilanow
 * Added to the CVS first time.
 * 
 **/

/***********************************************************************
@
@ SPA.h
@
@ Description:
@ -----------
@ Header file which defines constants used by SPAspatialBound and its
@ subroutines, SPAgetBVal and SPAgetModParams.
@
@     NOTE:  Certain constants are all labelled as SWATH_MODEL_
@            because they define default values for parameters 
@            that are read in from a text file.  These help define the
@            swath boundary function used in the spatial search.
@
@             These constants are:
@
@               SPA_SWATH_MODEL_ORBIT_INCLINATION
@               SPA_SWATH_MODEL_KILOMETERS_PER_DEGREE
@               SPA_SWATH_MODEL_FLATCOEFF
@               SPA_SWATH_MODEL_ORBIT_PERIOD
@               SPA_SWATH_MODEL_ORBIT_PRECESSION
@               SPA_SWATH_MODEL_EARTH_RATE
@
@              A desciption of these parameters, and how they are
@              used in the algorithm is included below.
@
@            One input parameter to SPAspatialBound also helps define 
@            the swath model.  That is the swath width, which is input
@            in kilometers.
@
@            Note that certain of these parameters could be set equal to
@            others that are used from the PPS TS_Global area, but
@            their separate designation as "SPA_SWATH_MODEL_" variables
@            serves as reminder that, in the context of this algorithm
@            these serve simply as model parameters in the swath shape
@            definition.  The swath model is an approximation of the
@            true shape which actually varies with S/C attitude
@            variations, etc.  The values in this SPA.h file may be set
@            differently than the TS_GLOBAL.h values to provide a
@            refined default swath shape.
@
@            These parameters and their associated TS_Global constant
@            names are noted together below for easy reference:
@
@            Spatial Search Constant          TS_Global related constant
@            -----------------------          --------------------------
@
@            SPA_SWATH_MODEL_FLATCOEFF        FLATC
@            SPA_SWATH_MODEL_EARTH_RATE       OMEGA
@
@ The following constants are picked up from the TS_Global.h file for
@ PPS:
@
@    RAD2DEG     (Radians to Degrees factor, used in SPAgetBVal)
@    DEG2RAD     (Degrees to Radians factor, used in SPAspatialBound)
@    TS_SUCCESS  (The constant, used everywhere, defining successful
@                 returns: nominally 0 )
@
@
@
@ Date            Programmer Name         Change Description
@ -------------   ---------------   ------------------------------------
@ Sept. 9, 1996   Steve Bilanow     First created
@
@ Sept.19, 1996   Steve Bilanow     Certain constants taken from
@                                   TS_Global
@
@ Nov. 20, 1996   Steve Bilanow     Reorganized constants and added
@                                   tolerances from defaults for use in
@                                   the new routine SPAgetModParams
@                                   which reads a new input file.  Added
@                                   constants 0.0,1.0,2.0,90.0,180.0,
@                                   360.0, and miscellaneous typos
@                                   corrected.
@
@ Mar. 25, 1997   Steve Bilanow     Refined the default swath parameters
@                                   and swath parameter tolerances (used
@                                   for of the file values).  Tolerances
@                                   opened wider to be consistent with
@                                   orbit variability and tuning that
@                                   might be applied later.  Default
@                                   values based on a fit to an orbit
@                                   which is believed to be
@                                   representative of the "middle of the
@                                   box" for the target orbit.
@ Dec. 28, 2011   Michael Hensley   Added includes of C libraries,
@                                   TS_GLOBAL.h, and TS_SPA_52.h
@
***********************************************************************/

#ifndef _SPA_H
#define _SPA_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TS_SPA_52.h"

#include "TS_GLOBAL.h"

/*-------------------------- CONSTANTS -------------------------------*/

           /************************************************/
           /************************************************/
           /* Note:  The following are the swath model     */
           /* parameter default constants and tolerences,  */
           /* and are used in SPAgetModParams.             */
           /************************************************/
           /************************************************/
           /* Note that for each default value for the     */
           /* swath model parameters, there is a tolerence */
           /* value used for checking the sanity of the    */
           /* updated values which are read from the file. */
           /* The default values are for the TRMM swath    */
           /************************************************/
           /************************************************/

#define SPA_SWATH_MODEL_ORBIT_INCLINATION     34.968
				/* TRMM orbit inclination (deg) */

#define SPA_SWATH_MODEL_ORBIT_INCLINATION_TOL  2.0
				/* Tolerance for orbit inc. */

                                /***************************************
                                *  TRMM Orbit Inclination in Degrees.  *
                                *      and tolerance for check.        *
                                *                                      *
        IMPORTANT NOTE >>       *  Note:  The actual orbit inclination *
                                *  that is achieved by the Japanese    *
                                *  rocket will be slightly different   *
                                *  than this due to orbit injection    *
                                *  uncertainties.  Therefore, this     *
                                *  swath model parameter could be      *
                                *  updated after launch to provide a   *
                                *  slightly improved swath model.      *
                                *  This is not required, but could     *
                                *  be desirable if the achieved        *
                                *  inclination is significantly        *
                                *  different.                          *
                                ***************************************/

                  /*****************************************************
                  *  Parameter Tuning Note (4-25-97):                  *
                  *  ------------------------------                    *
                  *  Comparison of the swath model with FDF            *
                  *  simulated orbits shows a strong correlation       *
                  *  between the value of the orbit inclination and    *
                  *  the Earth oblateness value used.  Since the       *
                  *  spatial searth swath model works in geocentric    *
                  *  coordinates, the optimal inclination used         *
                  *  is given by the maximum geocentric (not geodetic) *
                  *  latitude reached in the orbit.  For the           *
                  *  nominal Earth flattening coefficient (0.3353)     *
                  *  the nominal 35 degree inclination orbit           *
                  *  apparently reaches about 34.968 degrees           *
                  *  in geocentric latitude for our sample orbit       *
                  *  (and about 35.149 degrees in geodetic latitude).  *
                  *  However apparently we could use a truer value of  *
                  *  the orbit inclination and adjust the oblateness   *
                  *  coefficient accordingly to have as good a fit.    *
                  *****************************************************/

#define SPA_SWATH_MODEL_KILOMETERS_PER_DEGREE    111.2
				/* km/deg in swath */

#define SPA_SWATH_MODEL_KILOMETERS_PER_DEGREE_TOL  2.0
				/* tolerance on km/deg */

                                       /********************************
                                       *  Approximate mean number of   *
                                       *  kilometers per angular       *
                                       *  degree of swath width,       *
                                       *  used in converting input     *
                                       *  swaths for each instrument   *
                                       *  to angular measure for the   *
                                       *  spherical trig. swath model. *
                                       *  E.g.,a 6378.137 equatorial   *
                                       *  radius gives 111,31949 km/deg*
                                       *  but the Earth radius at 35deg*
                                       *  latitude,~6371.0, gives      *
                                       *  111.19493 km/deg.            *
                                       ********************************/ 

#define SPA_SWATH_MODEL_FLATCOEFF      0.003353
				/* Earth flattening coef */

#define SPA_SWATH_MODEL_FLATCOEFF_TOL  0.01
				/* Tolerance on flat coef */

                                         /******************************
                                         *  Coefficient for Earth      *
                                         *  flattening for ellipsoid   *
                                         *  shape model.               *
                                         ******************************/

              /*********************************************************
              *  Note:  In the context of the Spatial Search algorithm,*
              *  the Earth flattening coefficient is only used in a    *
              *  a formula to convert geodetic to geocentric latitude  *
              *  for the swath boundary function computation.  Thus    *
              *  it essentially part of the swath shape model.         *
              *********************************************************/

#define SPA_SWATH_MODEL_ORBIT_PERIOD    5478.8
				/* Orbit Period in seconds */

#define SPA_SWATH_MODEL_ORBIT_PERIOD_TOL  30.0
				/* Orbit Period tolerance */

                                          /*****************************
                                          *  An average orbital period *
                                          *  is needed, as this helps  *
                                          *  define the adjustment for *
                                          *  the Earth rotation under  *
                                          *  the swath path.           *
                                          *****************************/

#define SPA_SWATH_MODEL_ORBIT_PRECESSION     -0.431
				/* Orbit precession (degrees/orbit) */

#define SPA_SWATH_MODEL_ORBIT_PRECESSION_TOL  1.0
				/* Tolerance on orbit precession */

                                           /****************************
                                           *  An average rate is used  *
                                           *  to define a small        *
                                           *  correction of the swath  *
                                           *  shape for orbit          *
                                           *  precession.              *
                                           ****************************/

#define SPA_SWATH_MODEL_EARTH_RATE      0.004178
				/* Earth rotation rate (degrees/sec) */
       
#define SPA_SWATH_MODEL_EARTH_RATE_TOL  0.000040
				/* Tolerance on Earth rate */

                                          /*****************************
                                          *  The Earth rotation rate   *
                                          *  is needed, as this helps  *
                                          *  define the adjustment for *
                                          *  the Earth rotation under  *
                                          *  the swath path.           *
                                          *****************************/

      /*****************************************************************
      *  Additional Note regarding swath model parameters:             *
      *  One key swath model parameter which is different for the      *
      *  three TRMM rain instruments is an input value to              *
      *  SPAspatialBound which is to be taken from the PPS database    *
      *  by the RST code which calls SPAspatialBound.                  *
      *                                                                *
      *  The nominal values for each instrument are approximately:     *
      *                                                                *
      *     PR   215 km                                                *
      *     TMI  760 km                                                *
      *     VIRS 720 km                                                *
      *                                                                *
      *****************************************************************/



           /***********************************************/
           /***********************************************/
           /* The following are used in SPAspatialBound.c */
           /***********************************************/
           /***********************************************/

#define SPA_DEFAULT_ASCMIN1  -999.0      /* Default value for ascmin1 */
#define SPA_DEFAULT_ASCMAX1  -999.0      /* Default value for ascmax1 */
#define SPA_DEFAULT_DESMIN1  -999.0      /* Default value for desmin1 */
#define SPA_DEFAULT_DESMAX1  -999.0      /* Default value for desmax1 */
#define SPA_DEFAULT_ASCMIN2   999.0      /* Default value for ascmin2 */
#define SPA_DEFAULT_DESMIN2   999.0      /* Default value for desmin2 */

                /******************************************************/
                /* Note: The above default values are returned if the */
                /*       inputs are invalid or if the input box is    */
                /*       entirely north or south of the swath.  They  */
                /*       are selected so that if they are used anyway */
                /*       in a spatial search query of the database,   */
                /*       no orbits would be found to intersect the    */
                /*       box.                                         */
                /******************************************************/

                                        /******************************/
                                        /* Return Codes for bad input */
                                        /******************************/

#define SPA_RETURN1_NEG_SWATH_WIDTH   1     /* Negative swath width   */
#define SPA_RETURN2_MIN_GT_MAX_LAT    2     /* min > max latitude     */
#define SPA_RETURN3_MIN_GT_MAX_LON    3     /* min > max longitude    */
#define SPA_RETURN4_BOX_N_OR_S_SWATH  4     /* Box all north or south */
                                            /* of swath boundaries    */

                                       /*******************************/
                                       /* Return Code for any errors  */
                                       /* encountered in reading the  */
                                       /* swath model parameters file */
                                       /*******************************/

#define SPA_RETURN5_DEFAULT_MODEL_PARAMS  5
				/* Default Model Parameters */

                              /****************************************/
                              /* Min and Max values of Lon_of_Max_Lat */
                              /* as stored in PPS database            */
                              /****************************************/

#define SPA_LON_OF_MAX_LAT_MIN  -180.0           /* minimum longitude */
#define SPA_LON_OF_MAX_LAT_MAX  +180.0           /* maximum longitude */



          /*********************************************/
          /*********************************************/
          /* Note:  The following are used in both     */
          /* SPAspatialBound and SPAgetBVal, except    */
          /* 90.0 is only used in SPAspatialBound, and */
          /* 180.0 is only used in SPAgetBVal.         */
          /*********************************************/
          /*********************************************/

                                /**************************************/
                                /* Constants for formulas as required */
                                /**************************************/


#define SPA_ZERO_POINT_ZERO           0.0   /*  0.0                   */
#define SPA_ONE_POINT_ZERO            1.0   /*  1.0                   */
#define SPA_TWO_POINT_ZERO            2.0   /*  2.0                   */
#define SPA_NINETY_POINT_ZERO        90.0   /* Degrees in right angle */
#define SPA_ONE_EIGHTY_POINT_ZERO   180.0   /* Degrees in half circle */
#define SPA_THREE_SIXTY_POINT_ZERO  360.0   /* Degrees in full circle */



   /*************************************************************/
   /*************************************************************/
   /* Note:  The following constants from TS_Global.h for PPS   */
   /*        values as of 9-17-96 version noted for reference:  */
   /*                                                           */
   /*        DEG2RAD  0.017453292   (used in SPAspatialBound)   */
   /*        RAD2DEG      57.29578  (used in SPAgetBVal)        */
   /*        TS_SUCCESS    0        (used in all SPA functions  */
   /*************************************************************/
   /*************************************************************/

#endif
