/* CVS Comment Section
 * 
 * $Log: SPAproto.h,v $
 * Revision 1.1.1.1  2011/12/30 02:47:49  hensley
 * First import
 *
 * 
 * Checked into sturmmitte CVS as "spacomlin" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * Revision 1.1.1.1  2008/08/19 21:17:02  hensley
 * First Import
 * 
 * Checked into sturmmitte CVS as "spaweb" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * Revision 1.1.1.1  2008/06/18 23:06:08  hensley
 * Baseline PPS-- Code
 * 
 * Linux CVS Comments When Imported as "spa" ^^^
 * ---------------------------------------------------------------------
 * ---------------------------------------------------------------------
 * SGI CVS Comments vvv
 * 
 * Revision 1.4  2006/12/01 03:41:56  hensley
 * Fixed CVS Comment Section
 * 
 * Revision 1.3  1996/11/22 22:19:36  bilanow
 * added #include UTerrHandle.h in quotes
 * 
 * Revision 1.2  1996/11/21  22:32:35  bilanow
 * New and modified prototypes and new include.
 * 
 * Revision 1.1  1996/11/14  18:51:22  dbazell
 * moved file from spat/ to spa/
 * 
 * Revision 1.1  1996/09/20  19:36:17  bilanow
 * Added to the CVS first time.
 * 
 **/

/***********************************************************************
@
@ SPAproto.h
@
@ Description:
@ -----------
@ Header file to declare the subroutine prototype needed to use
@ SPAspatialBound.  The function prototype of its subroutine,
@ SPAgetBVal is also noted.
@
@
@ Date            Programmer Name   Change Description
@ ----            ---------------   ------------------------------------
@ Sept. 9, 1996   Steve Bilanow     First created.
@
@ Sept.11, 1996   Udaya Adusumalli  ifndef, and #include "SPA.h added
@                 Steve Bilanow     SPAgetBVal included here from
@                                   SPAspatialBound
@
@ Nov. 21, 1996   Steve Bilanow     Added prototype for SPAgetModParams
@                                   Included TS_SPA_52.h for error
@                                   messages.  Modified prototype for
@                                   SPAgetBVal.
@ June 18, 2008   Michael Hensley   Added fileID to the calls to
@                                   SPAspatialBound and SPAgetModParams
@
***********************************************************************/

#ifndef	_SPA_PROTO_H
#define	_SPA_PROTO_H

#include "SPA.h"

      /************************************************************/
      /* Prototype for external functions (using SPAspatialbound) */
      /************************************************************/

int SPAspatialBound (char  *fileID,  float swathw,
                     float latmin,   float latmax, 
                     float lonmin,   float lonmax, 
                     float *ascmin1, float *ascmax1, 
                     float *desmin1, float *desmax1, 
                     float *ascmin2, float *desmin2);

      /***********************************************************/
      /* Prototpye for local functions (used by SPAspatialBound) */
      /***********************************************************/

int SPAgetModParams(char  *fileID,
                    float *orbit_inclination,
                    float *kilometers_per_deg,
                    float *flatcoeff,
                    float *orbit_period,
                    float *orbit_precession,
                    float *earth_rate);

void SPAgetBVal(float theta, float phi, float gamma, 
                float orbit_period, float orbit_precession,
                float earth_rate, float *lon);

#endif
