/* CVS Comment Section
 * 
 * $Log: comOff.h,v $
 * Revision 1.2  2011/12/30 23:13:36  hensley
 * Removed UT.h
 *
 * Revision 1.1  2011/10/19 20:01:58  hensley
 * First import
 *
 * 
 */

/***********************************************************************
* comOff.h
*
* Include file for the command line version of the TRMM overflight
* finder.  Contains C include files, PPS module include files, and
* command line overflight finder code prototypes.
*
* Date		Programmer		Comments
* 12-OCT-11	Michael Hensley		First written
***********************************************************************/

#ifndef __COMOFF_H__
#define __COMOFF_H__

/*******************/
/* C include files */
/*******************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

/****************************/
/* PPS module include files */
/****************************/

#include "inputData.h"
#include "orbitInfo.h"
#include "PGS_TD.h"
#include "SPAproto.h"
#include "TS_GLOBAL.h"
#include "UT_TIME.h"

/*********************************************/
/* Command line overflight finder prototypes */
/*********************************************/

sOrbitInfo *findOrbits(float, float, float *, int *, int *);

int findOrbNums(int [], int [], int [], int *, int *);

int getLonMaxLatA (int, int, float [], double []);

float timeVSRLon (float);

#endif
