/* CVS Comment Section
 * 
 * $Log: timeVSRLon.c,v $
 * Revision 1.2  2011/07/01 22:46:34  hensley
 * TSDIS to PPS
 *
 * Revision 1.1.1.1  2008/08/20 23:54:54  hensley
 * First Import
 *
 * 
 * ---------------------------------------------------------------------
 * PPS CVS ^^
 * 
 * TSDIS CVS vv
 * ---------------------------------------------------------------------
 * 
 * Revision 1.2  2002/08/12 17:21:58  hensley
 * Fixed CVS header section
 * 
 * Revision 1.1.1.1  2000/11/10 23:11:58  hensley
 * Baseline Source Code
 * 
 * */

/**************************************************************************
* Function Statement:
* -------------------
* float timeVSRLon (float rlon)
* 
* Description:
* ------------
* This function evaluates a fixed polynomial which represents a fit taken
* from TRMM data for the time from the orbit start time versus the
* longitude relative to the longitude of maximum latitude.
* 
* Input Parameters:
* ----------------
* rlon		relative longitude (to point of max latitude)
* 
* Output Parameters:
* -----------------
* none
* 
* Return:     
* -------
* float value giving time in minutes from the orbit start (assuming
* TRMM/PPS type granules starting at southernmost point).
* 
* Called By:
* ---------
* findOrbits
* 
* Routines Called:
* ---------------
* none
* 
* Date		Programmer Name		Change Description
* ----		---------------		------------------
* 		Steve Bilanow		First written (rapid prototype)
* 01-JUL-99	Michael A. Hensley	Cleaned up and commented
* 12-OCT-00	Michael A. Hensley	Cleaned up and commented more
**************************************************************************/

/*********************************************************/
/* global variable declaration - doubles used internally */
/* to avoid underflow                                    */
/*********************************************************/

double xrlon;
double xrlon2;
double xrlon3;
double xrlon4;
double xrlon5;
double xrlon6;
double xrlon7;
double xrlon8;
double xrlon9;
float time;

/*****************/
/* routine start */
/*****************/

float timeVSRLon (float rlon)

{

/*****************************************************************/
/* local variable definition - cast as double to avoid underflow */
/*****************************************************************/

   xrlon = (double) rlon;

/**************************************/
/* get powers of xrlon for polynomial */
/**************************************/

   xrlon2 = xrlon  * xrlon;
   xrlon3 = xrlon2 * xrlon;
   xrlon4 = xrlon3 * xrlon;
   xrlon5 = xrlon4 * xrlon;
   xrlon6 = xrlon5 * xrlon;
   xrlon7 = xrlon6 * xrlon;
   xrlon8 = xrlon7 * xrlon;
   xrlon9 = xrlon8 * xrlon;

/********************************************************************/
/* Evaluate polynomial - current numbers based on fit to orbit 2783 */
/********************************************************************/

   time =    45.629448
        +  0.21451856    * xrlon
        +  5.0650895e-07 * xrlon2
        +  1.2383787e-05 * xrlon3
        + -4.0865755e-11 * xrlon4
        + -7.3389854e-10 * xrlon5
        +  2.0367898e-15 * xrlon6
        +  1.6112063e-14 * xrlon7
        + -4.0260075e-20 * xrlon8
        + -1.1008788e-19 * xrlon9;

   return time;

}
